/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.momd;

import com.ibm.hwmca.base.momd.MOMDebugConstants;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.NodeDescriptor;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class MOMDebugNodeBranch
implements MOMDebugConstants {
    private NodeDescriptor me;
    private MOMDebugNodeBranch[] children;
    private Set fields;
    private Set origFields;
    private PanelBean toUse;
    Object stack;

    public MOMDebugNodeBranch(Object base, PanelBean user) {
        this.me = base instanceof NodeDescriptor ? (NodeDescriptor)base : null;
        this.toUse = user;
        this.origFields = null;
        this.fields = null;
        this.children = null;
    }

    public synchronized void setData(Object toSet) {
        Trace.trace("XMOMD TT", "-> setData(Object)");
        while (this.stack != null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.stack = toSet;
        this.notify();
        Trace.trace("XMOMD TT", "<- setData()");
    }

    public NodeDescriptor getNode() {
        Trace.trace("XMOMD TT", "<> getNode()");
        return this.me;
    }

    public synchronized NodeDescriptor[] getChildNodes() {
        Trace.trace("XMOMD TT", "-> getChildNodes()");
        if (this.children == null) {
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("Action", "GetKiddies");
            request.setData("Node", this.me != null ? this.me.getName() : null);
            try {
                Trace.trace("XMOMD TD", "Posting the tasklet request to fetch children");
                this.toUse.postTaskletRequest(request);
                Trace.trace("XMOMD TD", "Preparing to wait");
                this.wait();
            }
            catch (InterruptedException e) {
                Trace.trace("XMOMD TD", "NodeBranch waking up");
            }
            this.setChildNodeData((Set)this.stack);
            this.stack = null;
        }
        NodeDescriptor[] toReturn = new NodeDescriptor[this.children.length];
        for (int i = 0; i < this.children.length; ++i) {
            toReturn[i] = this.children[i].getNode();
        }
        Trace.trace("XMOMD TT", "<- getChildNodes()");
        return toReturn;
    }

    protected synchronized void setChildNodeData(Set data) {
        Trace.trace("XMOMD TT", "-> setChildNodeData()");
        this.children = MOMDebugNodeBranch.buildNodes(data, this.toUse);
        Trace.trace("XMOMD TT", "<- setChildNodeData()");
    }

    private static MOMDebugNodeBranch[] buildNodes(Set data, PanelBean toUse) {
        Trace.trace("XMOMD TT", "-> buildNodes()");
        MOMDebugNodeBranch[] toReturn = new MOMDebugNodeBranch[]{};
        if (data != null) {
            toReturn = new MOMDebugNodeBranch[data.size()];
            int x = 0;
            Iterator iterator = data.iterator();
            while (iterator.hasNext()) {
                NodeValue entry = (NodeValue)iterator.next();
                Trace.trace("XMOMD TT", "Building named node");
                toReturn[x] = new MOMDebugNodeBranch(new NodeDescriptor(entry.getName(), entry.getDisplayName()), toUse);
                toReturn[x].me.setLeaf(false);
                ++x;
            }
        }
        Trace.trace("XMOMD TT", "<- buildNodes()");
        return toReturn;
    }

    public synchronized ItemDescriptor[] getPropertyData() {
        Trace.trace("XMOMD TT", "-> getPropertyData()");
        if (this.me != null && this.fields == null) {
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("Action", "AboutMe");
            request.setData("Node", this.me.getName());
            try {
                this.toUse.postTaskletRequest(request);
                this.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.setPropertyData((Set)this.stack);
            this.stack = null;
            this.origFields = this.fields;
        } else if (this.me == null) {
            this.fields = new TreeSet();
        }
        ItemDescriptor[] toReturn = new ItemDescriptor[this.fields.size() * 2];
        int x = 0;
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            PropertyValue propertyValue = (PropertyValue)iterator.next();
            String name = propertyValue.getName();
            toReturn[x * 2] = new ItemDescriptor(name + "name", propertyValue.getDisplayName());
            toReturn[x * 2 + 1] = new ItemDescriptor(name + "value", propertyValue.getValue());
            ++x;
        }
        Trace.trace("XMOMD TT", "<- getPropertyData()");
        return toReturn;
    }

    private synchronized void setPropertyData(Set data) {
        Trace.trace("XMOMD TT", "-> setPropertyData()");
        this.fields = data;
        Trace.trace("XMOMD TT", "<- setPropertyData()");
    }

    public MOMDebugNodeBranch retrieveByName(String name) {
        Trace.trace("XMOMD TT", "-> retrieveByName(name=" + name + ")");
        MOMDebugNodeBranch toReturn = null;
        if (name == null) {
            toReturn = this;
        } else if (this.me != null && this.me.getName().equals(name)) {
            toReturn = this;
        } else if (this.children != null) {
            for (int i = 0; i < this.children.length && (toReturn = this.children[i].retrieveByName(name)) == null; ++i) {
            }
        }
        Trace.trace("XMOMD TT", "<- retrieveByName()");
        return toReturn;
    }

    public void reset() {
        Trace.trace("XMOMD TT", "<> reset()");
        this.fields = this.origFields;
    }

    public synchronized void setPropertyData(ItemDescriptor[] elements) {
        Trace.trace("XMOMD TT", "-> setPropertyData(" + elements.length / 2 + " rows)");
        this.fields = new HashSet();
        for (int x = 0; x < elements.length / 2; ++x) {
            String name = elements[x * 2].getName();
            name = name.substring(0, name.length() - "name".length());
            String value = elements[x * 2 + 1].toString();
            boolean changed = false;
            Iterator iterator = this.origFields.iterator();
            while (iterator.hasNext()) {
                PropertyValue propertyValue = (PropertyValue)iterator.next();
                if (!propertyValue.getName().equals(name)) continue;
                changed = propertyValue.getValue().equals(value);
                propertyValue.setValue(value);
                break;
            }
            if (changed) continue;
            name = name.substring(name.lastIndexOf(124) + 1);
            Trace.trace("XMOMD TF", "Setting the property: " + name + " to value: " + value);
            this.fields.add(new PropertyValue(name, null, value));
        }
        if (this.fields.size() > 0) {
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("Action", "STORENOW");
            request.setData("Node", this.me != null ? this.me.getName() : null);
            request.setData("DATA", this.fields);
            Trace.trace("XMOMD TD", "Posting the tasklet request to set children");
            this.toUse.postTaskletRequest(request);
        }
        Trace.trace("XMOMD TT", "<- setPropertyData()");
    }

    public static class NodeValue
    implements Comparable,
    Serializable {
        private String name;
        private Comparable displayName;

        public NodeValue(String name, Comparable displayName) {
            this.name = name;
            this.displayName = displayName;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName.toString();
        }

        public int compareTo(Object test) {
            return this.displayName.compareTo(((NodeValue)test).displayName);
        }

        public boolean equals(Object test) {
            return test instanceof NodeValue && this.name.equals(((NodeValue)test).name);
        }

        public String toString() {
            StringBuffer result = new StringBuffer("displayName=").append(this.displayName.toString()).append(",name=").append(this.name);
            return result.toString();
        }
    }

    public static class PropertyValue
    implements Comparable,
    Serializable {
        private String name;
        private Comparable displayName;
        private String value;

        public PropertyValue(String name, Comparable displayName, String value) {
            this.name = name;
            this.displayName = displayName;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName.toString();
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public int compareTo(Object test) {
            int result = 0;
            if (this.displayName == null) {
                if (((PropertyValue)test).displayName != null) {
                    result = 1;
                }
            } else {
                result = this.displayName.compareTo(((PropertyValue)test).displayName);
            }
            return result;
        }

        public boolean equals(Object test) {
            boolean result = false;
            if (test instanceof PropertyValue) {
                result = this.name.equals(((PropertyValue)test).name) && (this.value == null && ((PropertyValue)test).value == null || this.value != null && this.value.equals(((PropertyValue)test).value));
            }
            return result;
        }

        public String toString() {
            StringBuffer result = new StringBuffer("displayName=").append(this.displayName).append(",name=").append(this.name).append(",value=").append(this.value);
            return result.toString();
        }
    }
}

